# This is an example program of how to use the Vaunix LSG DLL
# from python to control a single LSG device

from ctypes import *
vnx= cdll.vnx_fsynth
vnx.fnLSG_SetTestMode(False)        # Use actual devices
DeviceIDArray = c_int * 20
Devices = DeviceIDArray()           # This array will hold the list of device handles
                                    # returned by the DLL

# GetNumDevices will determine how many LSG devices are availible
numDevices = vnx.fnLSG_GetNumDevices()
print(str(numDevices), ' device(s) found')

# GetDevInfo generates a list, stored in the devices array, of
# every availible LSG device attached to the system
# GetDevInfo will return the number of device handles in the array
dev_info = vnx.fnLSG_GetDevInfo(Devices)
print('GetDevInfo returned', str(dev_info))

# GetSerialNumber will return the devices serial number
ser_num = vnx.fnLSG_GetSerialNumber(Devices[0])
print('Serial number:', str(ser_num))

#InitDevice wil prepare the device for operation
init_dev = vnx.fnLSG_InitDevice(Devices[0])
print('InitDevice returned', str(init_dev))


print()

# These functions will get the frequency range of the LSG device
# and those frequencies will be turned into MHz
min_freq = vnx.fnLSG_GetMinFreq(Devices[0])
max_freq = vnx.fnLSG_GetMaxFreq(Devices[0])
min_freq_in_MHz = int(min_freq / 10)
max_freq_in_MHz = int(max_freq / 10)
print('Minimum output frequency for LSG device in MHz:', min_freq_in_MHz)
print('Maximum output frequency for LSG device in MHz:', max_freq_in_MHz)


print('Enter desired output frequency in MHz: ', end = '')
# This is where the user can enter in the output frequency for the LSG device
freq = float(input())

# This prevents the user from entering an output frequency outside of
# the devices range
while freq > max_freq_in_MHz or freq < min_freq_in_MHz:
    print('Enter a value between', min_freq_in_MHz, 'and', max_freq_in_MHz,': ', end = '')
    freq = float(input())
    
Hz = freq * 1000000
frequency = Hz / 100000

# This sets the output frequency for the LSG device
result = vnx.fnLSG_SetFrequency(Devices[0], int(frequency))
if result != 0:
    print('SetFrequency returned error', result)
    
print()

# These functions get the minimum and maximum power of the LSG device
min_power = vnx.fnLSG_GetMinPwr(Devices[0])
max_power = vnx.fnLSG_GetMaxPwr(Devices[0])

min_pow = min_power / 4
max_pow = max_power / 4
print('Minimum power for LSG device:', min_pow)
print('Maximum power for LSG device:', max_pow)
print('Enter desired power level in db: ', end = '')

# This is what allows the user to enter in the desired power for the LSG device
power = float(input())

# Tis loop prevents the user from entering a power outside of the device's range
while power > max_pow or power < min_pow:
    print('Enter a value between', min_pow,'and', max_pow,': ', end = '')
    power = float(input())
    
powerlevel = power / .25

# This sets the power for the LSG device
result_1 = vnx.fnLSG_SetPowerLevel(Devices[0], int(powerlevel))
if result_1 != 0:
    print('SetPowerLevel returned error', result_1)

print()

# These two functions get the output frequency and the power of the LSG device
result = vnx.fnLSG_GetFrequency(Devices[0])
result_1 = vnx.fnLSG_GetPowerLevel(Devices[0])


freq = (result * 100000) / 1000000
power = (max_power - result_1) / 4

print('Output frequency for the LSG device:', freq)
print('Power level for LSG device:', power)

# This function closes the device
# You should always close the devie when finished with it
closedev = vnx.fnLSG_CloseDevice(Devices[0])
if closedev != 0:
    print('CloseDevice returned an error', closedev)

