﻿Module Vaunix_Sig_GEN
    ' Sample declarations for Vaunix Frequency synthesizer DLL
    ' VB .net style
    ' Note that a VB.net Integer is the same as a VB Long
    ' RD 10/24/12

    ' Useful constants -- status values that can be returned

    Const STATUS_OK As Integer = 0
    Const BAD_PARAMETER As Integer = &H80010000
    Const BAD_HID_IO As Integer = &H80020000
    Const DEVICE_NOT_READY As Integer = &H80030000

    Const INVALID_DEVID As Integer = &H80000000
    Const DEV_CONNECTED As Integer = &H1
    Const DEV_OPENED As Integer = &H2
    Const SWP_ACTIVE As Integer = &H4
    Const SWP_UP As Integer = &H8
    Const SWP_REPEAT As Integer = &H10


    ' void fnLSG_SetTestMode(bool testmode);
    Declare Sub fnLSG_SetTestMode Lib "vnx_fsynsth.dll" Alias "_fnLSG_SetTestMode@4" (ByVal testmode As Integer)

    ' int fnLSG_GetNumDevices();
    Declare Function fnLSG_GetNumDevices Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetNumDevices@0" () As Integer

    ' int fnLSG_GetDevInfo(DEVID *ActiveDevices);
    Declare Function fnLSG_GetDevInfo Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetDevInfo@4" (ByVal ActiveDevices As IntPtr) As Integer

    ' int fnLSG_GetDeviceStatus(DEVID deviceID);	
    Declare Function fnLSG_GetDeviceStatus Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetDeviceStatus@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetModelName(DEVID deviceID, char *ModelName);
    Declare Function fnLSG_GetModelName Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetModelName@8" (ByVal deviceID As Integer, ByVal modelname As String) As Integer

    ' int fnLSG_InitDevice(DEVID deviceID);
    Declare Function fnLSG_InitDevice Lib "vnx_fsynsth.dll" Alias "_fnLSG_InitDevice@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_CloseDevice(DEVID deviceID);
    Declare Function fnLSG_CloseDevice Lib "vnx_fsynsth.dll" Alias "_fnLSG_CloseDevice@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetSerialNumber(DEVID deviceID);
    Declare Function fnLSG_GetSerialNumber Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetSerialNumber@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_SetFrequency(DEVID deviceID, int attenuation);
    Declare Function fnLSG_SetFrequency Lib "vnx_fsynsth.dll" Alias "_fnLSG_SetFrequency@8" (ByVal deviceID As Integer, ByVal frequency As Integer) As Integer

    ' int fnLSG_SetStartFrequency(DEVID deviceID, int startfrequency);
    Declare Function fnLSG_SetStartFrequency Lib "vnx_fsynsth.dll" Alias "_fnLSG_SetStartFrequency@8" (ByVal deviceID As Integer, ByVal startfrequency As Integer) As Integer

    ' int fnLSG_SetEndFrequency(DEVID deviceID, int endfrequency);
    Declare Function fnLSG_SetEndFrequency Lib "vnx_fsynsth.dll" Alias "_fnLSG_SetEndFrequency@8" (ByVal deviceID As Integer, ByVal endfrequency As Integer) As Integer

    ' int fnLSG_SetFrequencyStep(DEVID deviceID, int frequencystep);
    Declare Function fnLSG_SetFrequencyStep Lib "vnx_fsynsth.dll" Alias "_fnLSG_SetFrequencyStep@8" (ByVal deviceID As Integer, ByVal frequencystep As Integer) As Integer

    ' int fnLSG_SetDwellTime(DEVID deviceID, int dwelltime);
    Declare Function fnLSG_SetDwellTime Lib "vnx_fsynsth.dll" Alias "_fnLSG_SetDwellTime@8" (ByVal deviceID As Integer, ByVal dwelltime As Integer) As Integer

    ' int fnLSG_SetPowerLevel(DEVID deviceID, int powerlevel);
    Declare Function fnLSG_SetPowerLevel Lib "vnx_fsynsth.dll" Alias "_fnLSG_SetPowerLevel@8" (ByVal deviceID As Integer, ByVal powerlevel As Integer) As Integer

    ' int fnLSG_SetRFOn(DEVID deviceID, bool on);
    Declare Function fnLSG_SetRFOn Lib "vnx_fsynsth.dll" Alias "_fnLSG_SetRFOn@8" (ByVal deviceID As Integer, ByVal rf_on As Integer) As Integer

    ' int fnLSG_SetSweepDirection(DEVID deviceID, bool up);
    Declare Function fnLSG_SetSweepDirection Lib "vnx_fsynsth.dll" Alias "_fnLSG_SetSweepDirection@8" (ByVal deviceID As Integer, ByVal ramp_up As Integer) As Integer

    ' int fnLSG_SetSweepMode(DEVID deviceID, bool mode);
    Declare Function fnLSG_SetSweepMode Lib "vnx_fsynsth.dll" Alias "_fnLSG_SetSweepMode@8" (ByVal deviceID As Integer, ByVal ramp_mode As Integer) As Integer

    ' int fnLSG_StartSweep(DEVID deviceID, bool go);
    Declare Function fnLSG_StartSweep Lib "vnx_fsynsth.dll" Alias "_fnLSG_StartSweep@8" (ByVal deviceID As Integer, ByVal start_sweep As Integer) As Integer

    ' int fnLSG_SetUseInternalRef(DEVID deviceID, bool internal);
    Declare Function fnLSG_SetUseInternalRef Lib "vnx_fsynsth.dll" Alias "_fnLSG_SetUseInternalRef@8" (ByVal deviceID As Integer, ByVal internal As Integer) As Integer

    ' int fnLSG_SaveSettings(DEVID deviceID);
    Declare Function fnLSG_SaveSettings Lib "vnx_fsynsth.dll" Alias "_fnLSG_SaveSettings@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetFrequency(DEVID deviceID);
    Declare Function fnLSG_GetFrequency Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetFrequency@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetStartFrequency(DEVID deviceID);
    Declare Function fnLSG_GetStartFrequency Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetStartFrequency@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetEndFrequency(DEVID deviceID);
    Declare Function fnLSG_GetEndFrequency Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetEndFrequency@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetDwellTime(DEVID deviceID);
    Declare Function fnLSG_GetDwellTime Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetDwellTime@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetFrequencyStep(DEVID deviceID);
    Declare Function fnLSG_GetFrequencyStep Lib "vnx_fsynsth.dll" Alias "_GetFrequencyStep@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetRF_On(DEVID deviceID);
    Declare Function fnLSG_GetRF_On Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetRF_On@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetUseInternalRef(DEVID deviceID);
    Declare Function fnLSG_GetUseInternalRef Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetUseInternalRef@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetMaxFreq(DEVID deviceID);
    Declare Function fnLSG_GetMaxFreq Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetMaxFreq@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetMinFreq(DEVID deviceID);
    Declare Function fnLSG_GetMinFreq Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetMinFreq@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetMinPwr(DEVID deviceID);
    Declare Function fnLSG_GetMinPwr Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetMinPwr@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetMaxPwr(DEVID deviceID);
    Declare Function fnLSG_GetMaxPwr Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetMaxPwr@4" (ByVal deviceID As Integer) As Integer

    ' int fnLSG_GetPowerLevel(DEVID deviceID);
    Declare Function fnLSG_GetPowerLevel Lib "vnx_fsynsth.dll" Alias "_fnLSG_GetPowerLevel@4" (ByVal deviceID As Integer) As Integer




End Module
