' Demonstration of calling the Vaunix Lab Brick support DLL from VB.net
' This example software does not have error checking, and is simply intended to show how to access the DLL functions
' actual production code should ensure that incorrect user inputs are detected, and handle any errors returned by
' the DLL functions. This demo software does display the status returned by most DLL calls in the debug output window. Production
' code should test the status return values and respond to any errors.
'
' This code is not intended as a style example for VB.net coding, nor is it necessarily optimal VB code




Imports System.IO 'Statement needed for Streamwriter function
Imports System.Threading
Imports System.Threading.Thread
Imports System.IO.Ports
Imports System.Text
Imports System.Runtime.InteropServices




Public Class Form1

    Private Property NumDevices As Integer
    Private Property iTemp As Integer
    Private Property iTestMode As Integer
    ' for a real application you'll want the device finding and init code to have wider scope than just one procedure, 
    ' so the variables related to device finding, etc. should have wider scope than just the button event handler
    ' you can create an init routine that finds and inits the devices. (you could also find, init, and close the devices
    ' within the scope of the button handler routine, but that may be harder to maintain and debug, depending on the overall
    ' design of your program
    Dim ActiveDevices(64) As Integer
    Private Property deviceID As Integer
    Dim LSG_Frequency As Single
    Dim LSG_Power As Single



    Private Sub Button27_Click(sender As System.Object, e As System.EventArgs) Handles Button27.Click
        ' This is the "on" button
        ' For this demo program the detection and set up of the hardware is done here, so the
        ' values for power and frequency should be set before clicking the button

        ' In order to get the array of deviceID handles from the DLL we need to create a temporary block of 
        ' unmanaged memory, and then copy the array from that block into a managed array
        ' There may be a shortcut way to do this, but I'm doing it as shown by Microsoft's example code

        ' Our managed array is declared outside of this function to have wider scope.
        ' (see above) Dim ActiveDevices(64) As Integer
        ' The size is more than we need for most applications, but it must always be at least as large
        ' as the value of MAX_DEVICES, which is 64 -- note that the VB array is actually one element larger than needed
        ' since VB.net specifies array size by the last index...

        ' Initialize unmanaged memory to hold the array. 
        Dim size As Integer = Marshal.SizeOf(ActiveDevices(0)) * ActiveDevices.Length

        Dim pnt As IntPtr = Marshal.AllocHGlobal(size)

        ' Note that the modelname initialized value must be the length of the actual device name string
        ' to use this shortcut to getting the device name. Production code should use either marshalling
        ' or init the modelname string length using the returned length from the DLL, or otherwise 
        ' convert the ASCII C style string from the DLL into a VB.net managed string
        Dim modelname As String
        modelname = "XXXXXXX"

        Dim iFrequency As Integer
        Dim iPowerLevel As Integer
        Dim iMaxPower As Integer

        ' For debug and demonstration purposes without hardware attached, allow the DLL to be set to test mode
        ' for actual operation set the argument to 0
        iTestMode = 1

        fnLSG_SetTestMode(iTestMode)

        ' find out how many devices are connected. In test mode there are two fake devices

        NumDevices = fnLSG_GetNumDevices()

        Debug.WriteLine("Number of Active Devices Found: " + NumDevices.ToString())

        ' get the deviceID handles for each of the connected devices, stored in the array ActiveDevices
        ' by first letting the DLL write the data into the unmanaged memory buffer pointed to by pnt
        ' and then Marshal copying it into ActiveDevices
        ' see http://msdn.microsoft.com/en-us/library/ms146635.aspx

        Try
            ' get the array of handles from the DLL
            iTemp = fnLSG_GetDevInfo(pnt)
            Debug.WriteLine("fnLSG_GetDevInfo returned: " + iTemp.ToString())
            ' copy them from the unmanaged buffer to a managed array
            Marshal.Copy(pnt, ActiveDevices, 0, ActiveDevices.Length)

        Finally
            ' Free the unmanaged memory.
            Marshal.FreeHGlobal(pnt)
        End Try

        If (NumDevices <> 0) Then

            Debug.WriteLine("The deviceID for the first device is: " + ActiveDevices(0).ToString())

            deviceID = ActiveDevices(0)


            iTemp = fnLSG_GetDeviceStatus(deviceID)
            Debug.WriteLine("fnLSG_GetDeviceStatus returned: " + iTemp.ToString())

            ' see note above regarding the shortcut way the string is obtained from the DLL
            iTemp = fnLSG_GetModelName(deviceID, modelname)
            Debug.WriteLine("fnLSG_GetModelName returned: " + iTemp.ToString())
            Debug.WriteLine("Lab Brick Model Name: " + modelname.ToString())

            iTemp = fnLSG_InitDevice(deviceID)
            Debug.WriteLine("fnLSG_InitDevice returned: " + iTemp.ToString())

            iTemp = fnLSG_GetSerialNumber(deviceID)
            Debug.WriteLine("fnLSG_GetSerialNumber returned: " + iTemp.ToString())



            iMaxPower = fnLSG_GetMaxPwr(deviceID)
            Debug.WriteLine("fnLSG_GetMaxPwr returned: " + iMaxPower.ToString())

            ' iFrequency = 20000 for example to get 2GHz output

            ' take the user's frequency input and convert it to our integer frequency
            ' frequency in MHZ input by the user is converted to 100 KHz units for the DLL
            ' watch for floating point round off and overflow issues in this kind of calculation
            ' decimal inputs and conversions to integer values can be easier to test

            LSG_Frequency = 10 * Convert.ToSingle(TextBox128.Text)
            iFrequency = Convert.ToInt32(LSG_Frequency)
            Debug.WriteLine("Frequency = " + LSG_Frequency.ToString() + " iFrequency = " + iFrequency.ToString())

            iTemp = fnLSG_SetFrequency(deviceID, iFrequency)
            Debug.WriteLine("fnLSG_SetFrequency returned: " + iTemp.ToString())

            'now we can turn set the power level and turn on the RF output
            'power level is set using an integer which is the number of db of attenuation in .25 db units, so we multiple the
            ' UI db value by 4, and subtract it from the max power.


            LSG_Power = Single.Parse(TextBox129.Text)
            iPowerLevel = Convert.ToInt32(LSG_Power * 4)

            iTemp = fnLSG_SetPowerLevel(deviceID, iPowerLevel)
            Debug.WriteLine("fnLSG_SetPowerLevel returned: " + iTemp.ToString())

            'and finally we can turn on the RF output
            iTemp = fnLSG_SetRFOn(deviceID, 1)
            Debug.WriteLine("fnLSG_SetRFOn returned: " + iTemp.ToString())

        End If




    End Sub


    Private Sub TextBox128_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBox128.TextChanged

    End Sub

    Private Sub Button28_Click(sender As System.Object, e As System.EventArgs) Handles Button28.Click
        ' This is the "off" button

        ' Show the device's settings
        iTemp = fnLSG_GetFrequency(deviceID)
        Debug.WriteLine("Frequency in 100KHz units is: " + iTemp.ToString())

        iTemp = fnLSG_GetPowerLevel(deviceID)
        Debug.WriteLine("Power attenuation in .25db units is: " + iTemp.ToString())


        'turn off the RF output
        iTemp = fnLSG_SetRFOn(deviceID, 0)
        Debug.WriteLine("fnLSG_SetRFOn returned: " + iTemp.ToString())

        'close our device so we can re-open it on the next click of the "on" button
        iTemp = fnLSG_CloseDevice(deviceID)
        Debug.WriteLine("fnLSG_CloseDevice returned: " + iTemp.ToString())

    End Sub
End Class

