// Include file for 64 Bit Vaunix Lab Brick LSG Synthesizer DLL
//
// Based on the 10/2013	RD	64 Bit DLL version.	
// RD 4/2016


// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the VNX_FSYNSTH_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// VNX_LSG_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.

#ifdef VNX_FSYNTH_EXPORTS
#define VNX_LSG_API __declspec(dllexport)
#else
#define VNX_LSG_API __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C" {
#endif


// ----------- Global Equates ------------
#define MAXDEVICES 64
#define MAX_MODELNAME 32

// ----------- Data Types ----------------
#define DEVID unsigned int

// ----------- Mode Bit Masks ------------
#define MODE_RFON	0x00000010			// bit is 1 for RF on, 0 if RF is off
#define MODE_INTREF	0x00000020			// bit is 1 for internal osc., 0 for external reference
#define MODE_SWEEP	0x0000000F			// bottom 4 bits are used to keep the sweep control bits				


// ----------- Command Equates -----------
// Status returns for commands
#define LVSTATUS int
#define STATUS_OK 0
#define BAD_PARAMETER		0x80010000		// out of range input -- frequency outside min/max etc.
#define BAD_HID_IO			0x80020000
#define DEVICE_NOT_READY	0x80030000		// device isn't open, no handle, etc.
#define F_INVALID_DEVID		-1.0		// for functions that return a float
#define F_DEVICE_NOT_READY	-3.0

// Status returns for DevStatus
#define INVALID_DEVID		0x80000000		// MSB is set if the device ID is invalid
#define DEV_CONNECTED		0x00000001		// LSB is set if a device is connected
#define DEV_OPENED			0x00000002		// set if the device is opened
#define SWP_ACTIVE			0x00000004		// set if the device is sweeping
#define SWP_UP				0x00000008		// set if the device is sweeping up in frequency
#define SWP_REPEAT			0x00000010		// set if the device is in continuous sweep mode
#define SWP_BIDIRECTIONAL	0x00000020		// set if the device is in bi-directional sweep mode
#define PLL_LOCKED			0x00000040		// set if the PLL lock status is TRUE (both PLL's are locked)


VNX_LSG_API void fnLSG_SetTestMode(bool testmode);
VNX_LSG_API int fnLSG_GetNumDevices();
VNX_LSG_API int fnLSG_GetDevInfo(DEVID *ActiveDevices);
VNX_LSG_API int fnLSG_GetModelNameA(DEVID deviceID, char *ModelName);
VNX_LSG_API int fnLSG_GetModelNameW(DEVID deviceID, wchar_t *ModelName);
VNX_LSG_API int fnLSG_InitDevice(DEVID deviceID);
VNX_LSG_API int fnLSG_CloseDevice(DEVID deviceID);
VNX_LSG_API int fnLSG_GetSerialNumber(DEVID deviceID);
VNX_LSG_API int fnLSG_GetDLLVersion();

VNX_LSG_API LVSTATUS fnLSG_SetFrequency(DEVID deviceID, int frequency);
VNX_LSG_API LVSTATUS fnLSG_SetStartFrequency(DEVID deviceID, int startfrequency);
VNX_LSG_API LVSTATUS fnLSG_SetEndFrequency(DEVID deviceID, int endfrequency);
VNX_LSG_API LVSTATUS fnLSG_SetFrequencyStep(DEVID deviceID, int frequencystep);
VNX_LSG_API LVSTATUS fnLSG_SetDwellTime(DEVID deviceID, int dwelltime);
VNX_LSG_API LVSTATUS fnLSG_SetPowerLevel(DEVID deviceID, int powerlevel);
VNX_LSG_API LVSTATUS fnLSG_SetRFOn(DEVID deviceID, bool on);

VNX_LSG_API LVSTATUS fnLSG_SetUseInternalRef(DEVID deviceID, bool internal);
VNX_LSG_API LVSTATUS fnLSG_SetSweepDirection(DEVID deviceID, bool up);
VNX_LSG_API LVSTATUS fnLSG_SetSweepMode(DEVID deviceID, bool mode);
VNX_LSG_API LVSTATUS fnLSG_StartSweep(DEVID deviceID, bool go);
VNX_LSG_API LVSTATUS fnLSG_SaveSettings(DEVID deviceID);

VNX_LSG_API int fnLSG_GetFrequency(DEVID deviceID);
VNX_LSG_API int fnLSG_GetStartFrequency(DEVID deviceID);
VNX_LSG_API int fnLSG_GetEndFrequency(DEVID deviceID);
VNX_LSG_API int fnLSG_GetDwellTime(DEVID deviceID);
VNX_LSG_API int fnLSG_GetFrequencyStep(DEVID deviceID);

VNX_LSG_API int fnLSG_GetRF_On(DEVID deviceID);
VNX_LSG_API int fnLSG_GetUseInternalRef(DEVID deviceID);
VNX_LSG_API int fnLSG_GetPowerLevel(DEVID deviceID);
VNX_LSG_API int fnLSG_GetPowerLevelAbs(DEVID deviceID);
VNX_LSG_API int fnLSG_GetMaxPwr(DEVID deviceID);
VNX_LSG_API int fnLSG_GetMinPwr(DEVID deviceID);
VNX_LSG_API int fnLSG_GetMaxFreq(DEVID deviceID);
VNX_LSG_API int fnLSG_GetMinFreq(DEVID deviceID);

VNX_LSG_API int fnLSG_GetDeviceStatus(DEVID deviceID);

#ifdef __cplusplus
}
#endif