// Include file for Vaunix Lab Brick Frequency Synthesizers
//
// 1/18/2009	RD	Fixed values of DevStatus bit masks.	
// 
// 1/23/2009	RD	Added new function for Minimum Power
//
// 11/10/2010	RD	VB6 compatible version
//
// The following #defines create the declarations for a program using the Microsoft Windows stdcall convention
// which is importing the dll functions.

#define VNX_FSYNSTH_API 

#define VB6_API __stdcall


// ----------- Global Equates ------------
#define MAXDEVICES 64
#define MAX_MODELNAME 32

// ----------- Data Types ----------------

#define DEVID unsigned int

// ----------- Mode Bit Masks ------------

#define MODE_RFON	0x00000010			// bit is 1 for RF on, 0 if RF is off
#define MODE_INTREF	0x00000020			// bit is 1 for internal osc., 0 for external reference
#define MODE_SWEEP	0x0000000F			// bottom 4 bits are used to keep the sweep control bits				


// ----------- Command Equates -----------


// Status returns for commands
#define LVSTATUS int

#define STATUS_OK 0
#define BAD_PARAMETER 0x80010000		// out of range input -- frequency outside min/max etc.
#define BAD_HID_IO    0x80020000
#define DEVICE_NOT_READY 0x80030000		// device isn't open, no handle, etc.

// Status returns for DevStatus

#define INVALID_DEVID 0x80000000		// MSB is set if the device ID is invalid
#define DEV_CONNECTED 0x00000001		// LSB is set if a device is connected
#define DEV_OPENED	  0x00000002		// set if the device is opened
#define SWP_ACTIVE	  0x00000004		// set if the device is sweeping
#define SWP_UP		  0x00000008		// set if the device is sweeping up in frequency
#define SWP_REPEAT	  0x00000010		// set if the device is in continuous sweep mode

// Internal values in DevStatus
#define DEV_LOCKED	  0x00000020		// set if we don't want read thread updates of the device parameters
#define DEV_RDTHREAD  0x00000040		// set when the read thread is running


VNX_FSYNSTH_API void VB6_API fnLSG_SetTestMode(bool testmode);
VNX_FSYNSTH_API int VB6_API fnLSG_GetNumDevices();
VNX_FSYNSTH_API int VB6_API fnLSG_GetDevInfo(DEVID *ActiveDevices);
VNX_FSYNSTH_API int VB6_API fnLSG_GetModelName(DEVID deviceID, char *ModelName);
VNX_FSYNSTH_API int VB6_API fnLSG_InitDevice(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_CloseDevice(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetSerialNumber(DEVID deviceID);


VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_SetFrequency(DEVID deviceID, int frequency);
VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_SetStartFrequency(DEVID deviceID, int startfrequency);
VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_SetEndFrequency(DEVID deviceID, int endfrequency);
VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_SetFrequencyStep(DEVID deviceID, int frequencystep);
VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_SetDwellTime(DEVID deviceID, int dwelltime);
VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_SetPowerLevel(DEVID deviceID, int powerlevel);
VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_SetRFOn(DEVID deviceID, bool on);
VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_SetUseInternalRef(DEVID deviceID, bool internal);
VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_SetSweepDirection(DEVID deviceID, bool up);
VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_SetSweepMode(DEVID deviceID, bool mode);
VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_StartSweep(DEVID deviceID, bool go);
VNX_FSYNSTH_API LVSTATUS VB6_API fnLSG_SaveSettings(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetFrequency(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetStartFrequency(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetEndFrequency(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetDwellTime(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetFrequencyStep(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetRF_On(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetUseInternalRef(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetPowerLevel(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetMaxPwr(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetMinPwr(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetMaxFreq(DEVID deviceID);
VNX_FSYNSTH_API int VB6_API fnLSG_GetMinFreq(DEVID deviceID);

