// --------------------------------- lswdrvr.h -------------------------------------------
//
//  Include file for Linux LabBrick rf switch defintions
//
// (c) 2021-2025 by Vaunix Technology Corporation, all rights reserved
//
//  NB  Version 1.0.1 LSW Ethernet Driver Interface Definitions
//-----------------------------------------------------------------------------

#define VNX_LSW_API __declspec(dllimport) 

/// ---------- Include headers ----------------

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif


    /// ---------- Macros ----------------
#define MAX_MODELNAME   32
#define MAX_SWVERSION   10
#define MAX_NETBUFF     16
#define MAX_SWDEVICES   12

// STATUS ENUM
#define STATUS_OK		0       // 0
#define STATUS_ERROR	1       // 1
#define LSWSTATUS 		int

// Hardware type values by device name (used in lda[DeviceId].DevType)
typedef enum
{
    LSW_802P4T = 1,
    LSW_802PDT,
    LSW_802P8T,
    LSW_203PDT,
    LSW_403PDT,
    MAX_LSW_DEVICEMODELS
}LSW_DEVICE_MODELS_T;

// Switch output port configuration
typedef enum
{
	SW_PORT1 = 1,
    SW_PORT2,
    SW_PORT3,
    SW_PORT4,
    SW_PORT5,
    SW_PORT6,
    SW_PORT7,
    SW_PORT8,
    MAX_SWPORTS
}LSW_SWPORT_T;

// LSW Device Response Data Structure
typedef struct
{
	//  Global device variables
    int serialnumber;
    char modelname[MAX_MODELNAME];
    char swversion[MAX_SWVERSION];
    int ipmode;
    char ipaddress[MAX_NETBUFF];
    char netmask[MAX_NETBUFF];
    char gateway[MAX_NETBUFF];
    int maxswitchdevices;
    int Maxswports;
    int rfswitchoutput[MAX_SWDEVICES];                  // the current channel number
    int NumSwitches;
} LSWDEVICE_DATA_T;

// LSW Device Init
VNX_LSW_API void fnLSW_Init(void);

// LSW Test mode
VNX_LSW_API void fnLSW_SetTestMode(bool testmode);

// Library version
VNX_LSW_API char* fnLSW_LibVersion(void);

// InitDevice
VNX_LSW_API LSWSTATUS fnLSW_InitDevice(char* deviceip);

// Close the Device Socket
VNX_LSW_API LSWSTATUS fnLSW_CloseDevice(char* deviceip);

// Device Ready
VNX_LSW_API LSWSTATUS fnLSW_CheckDeviceReady(char* deviceip);

// Get Model Name
VNX_LSW_API LSWSTATUS fnLSW_GetModelName(char* deviceip, char* respdata);

// Get Serial Number of the device
VNX_LSW_API LSWSTATUS fnLSW_GetSerialNumber(char* deviceip, int* respdata);

// Get SW Version of the device
VNX_LSW_API LSWSTATUS fnLSW_GetSoftwareVersion(char* deviceip, char* respdata);

// Get IP Mode of the device  0 - Static, 1 - DHCP
VNX_LSW_API LSWSTATUS fnLSW_GetIPMode(char* deviceip, int* respdata);

// Get IP Address of the device
VNX_LSW_API LSWSTATUS fnLSW_GetIPAddress(char* deviceip, char* respdata);

// Get Netmask of the device
VNX_LSW_API LSWSTATUS fnLSW_GetNetmask(char* deviceip, char* respdata);

// Get Gateway of the device
VNX_LSW_API LSWSTATUS fnLSW_GetGateway(char* deviceip, char* respdata);

// Get the base number of switches for the device
VNX_LSW_API LSWSTATUS fnLSW_GetNumSwitches(char* deviceip, int* respdata);

// Get Max Switch Devices
VNX_LSW_API LSWSTATUS fnLSW_GetMaxSwitchDevices(char* deviceip, int* respdata);

// Get Switch RF output state [Index range from 1 - 12]
VNX_LSW_API LSWSTATUS fnLSW_GetSwitchRFoutput(char* deviceip, int swindex, int* respdata);

// Set Switch RF output state [Index range from 1 - 12]
VNX_LSW_API LSWSTATUS fnLSW_SetSwitchRFoutput(char* deviceip, int swindex, LSW_SWPORT_T swport);

// Save Setting Callback
VNX_LSW_API LSWSTATUS fnLSW_SaveSettings(char* deviceip);

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif