import ctypes
import os
import time
import sys
import getopt
from time import sleep

def main():
    # Load the dynamic library (dylib) from the current directory
    lib_path = os.path.join(os.getcwd(), 'libLDA_socket.dylib')

    # You can also load the dynamic library (dylib) from the /usr/local/lib directory
    # which is typically used to store dylibs for user programs
    #lib_path = os.path.join('/usr/local/lib', 'libLDA_socket.dylib')

    vnx = ctypes.CDLL(lib_path)

    # Set test mode to false
    # This means that we will be using real devices
    vnx.fnLDA_SetTestMode(False)

    # Prompt the user to enter IP addresses for the devices they want to use
    while True:
        devIP = input("Enter device IP address to add device: ")
        # Add device to our list of devices
        if vnx.fnLDA_AddLDADevice(devIP.encode('utf-8')) != 0:
            print(f"Unable to add device with IP {devIP}")
        addDeviceChoice = input("Add another device? (Y/N): ")
        if addDeviceChoice == 'N' or addDeviceChoice == 'n':
            break
    print()

    # Get the number of devices
    devices_num = vnx.fnLDA_GetNumDevices()
    # Create an array of device ids for the connected devices
    DeviceIDArray = ctypes.c_int * devices_num
    devices_list = DeviceIDArray()
    # Fill the array with the ID's of connected attenuators
    vnx.fnLDA_GetDevInfo(ctypes.byref(devices_list))


    if len(devices_list) > 0:
        # Select which device to use
        devid = 0
        if len(devices_list) == 1:
            devid = devices_list[0]
        else:
            while not devid in devices_list:
                # Display some information about each connected device
                print("Connected Devices:")
                for device in devices_list:
                    vnx.fnLDA_InitDevice(device)
                    model_data = ctypes.create_string_buffer(32)
                    vnx.fnLDA_GetModelNameA(device, ctypes.byref(model_data))
                    print(f"\t({device}) Model: {model_data.value.decode('utf-8')}, SN: {vnx.fnLDA_GetSerialNumber(device)}")
                    vnx.fnLDA_CloseDevice(device)
                # Prompt user to select a device
                try:
                    devid = int(input("Select a device: "))
                    if not devid in devices_list:
                        print("Invalid device selection")
                except ValueError:
                    print("Invalid device selection")
                print()

        # selecting non-zero arguments to SetTraceLevel will generate
        # debug messages from the dylib
        # vnx.fnLDA_SetTraceLevel(1, 1, true)

        # Open selected device
        vnx.fnLDA_InitDevice(devid)
        
        # Get some basic information about device that we will need for later
        minAttenuation = int(vnx.fnLDA_GetMinAttenuationHR(devid) / 20)
        maxAttenuation = int(vnx.fnLDA_GetMaxAttenuationHR(devid) / 20)
        numChannels = vnx.fnLDA_GetNumChannels(devid)
  
        # Print some basic information about the device
        print_dev_info(vnx, devid)
        print()
        
        # Loop until the user decides to quit
        while True:
            # Prompt user for next action
            choice = ""
            print("Select an option:")
            print("\t(1) Change channel")
            print("\t(2) Change attenuation")
            print("\t(3) Quit")
            if len(devices_list) > 1:
                print("\t(4) Change Device")
                choice = input("Enter your choice (1/2/3/4): ")
            else:
                choice = input("Enter your choice (1/2/3): ")
            print()

            if choice == '1':       # Set the channel
                
                try:
                    channel = int(input(f"Enter a channel number between 1 and {numChannels}: "))
                    if channel >=1 and channel <= numChannels:
                        print(f"Setting channel to {channel}...")
                        vnx.fnLDA_SetChannel(devid, channel)
                    else:
                        print("Invalid channel selection")
                except ValueError:
                    print("Invalid channel selection")
                    
            elif choice == '2':     # Set the attenuation
                
                try:
                    print(f"Current attenuation is {vnx.fnLDA_GetAttenuationHR(devid)/20}")
                    attenuation = float(input(f"Enter an attenuation value between {minAttenuation} and {maxAttenuation}: "))
                    if attenuation >= minAttenuation and attenuation <= maxAttenuation:
                        print(f"Setting attenuation to {attenuation}...")
                        vnx.fnLDA_SetAttenuationHR(devid, int(attenuation * 20))
                    else:
                        print("Invalid attenuation selection")
                except ValueError:
                    print("Invalid attenuation selection")
                    
            elif choice == '3':     # Quit
                
                print("Quitting...")
                vnx.fnLDA_CloseDevice(devid)
                break
            
            elif choice == '4' and len(devices_list) > 1:       # Switch devices
                # Close the current device
                vnx.fnLDA_CloseDevice(devid)
                
                devid = 0
                while not devid in devices_list:
                    print("Connected Devices:")
                    for device in devices_list:
                        # Display some information about each connected device
                        vnx.fnLDA_InitDevice(device)
                        model_data = ctypes.create_string_buffer(32)
                        vnx.fnLDA_GetModelNameA(device, ctypes.byref(model_data))
                        print(f"\t({device}) Model: {model_data.value.decode('utf-8')}, SN: {vnx.fnLDA_GetSerialNumber(device)}")
                        vnx.fnLDA_CloseDevice(device)
                    # Prompt user to select a device
                    try:
                        devid = int(input("Select a device: "))
                        if not devid in devices_list:
                            print("Invalid device selection")
                    except ValueError:
                        print("Invalid device selection")
                    print()

                # Open selected device
                vnx.fnLDA_InitDevice(devid)
                
                # Get some basic information about device that we will need for later
                minAttenuation = int(vnx.fnLDA_GetMinAttenuationHR(devid) / 20)
                maxAttenuation = int(vnx.fnLDA_GetMaxAttenuationHR(devid) / 20)
                numChannels = vnx.fnLDA_GetNumChannels(devid)
                
                # Print some basic information about the device
                print_dev_info(vnx, devid)
                print()
            else:
                print("Invalid choice")
            print()
    else:
        print("No device found")
    
def print_dev_info(vnx, devid):
    print("\n*****************Current Information for the devices**********")
    print("Device #:", devid)

    model_data = ctypes.create_string_buffer(32)
    vnx.fnLDA_GetModelNameA(devid, ctypes.byref(model_data))
    print(f"Model Name:", model_data.value.decode('utf-8'))
    print("Serial #:", vnx.fnLDA_GetSerialNumber(devid))
    numChannels = vnx.fnLDA_GetNumChannels(devid)
    print("Min Frequency(MHz):", (vnx.fnLDA_GetMinWorkingFrequency(devid) / 10))
    print("Max Frequency(MHz):", (vnx.fnLDA_GetMaxWorkingFrequency(devid) / 10))
    print("Min Attenuation(dB):", (vnx.fnLDA_GetMinAttenuationHR(devid) / 20))
    print("Max Attenuation(dB):", (vnx.fnLDA_GetMaxAttenuationHR(devid) / 20))
    print("Num Channels:", numChannels)
    

if __name__ == "__main__":
    main()
    
