// Include file for 32 and 64 Bit Vaunix Lab Brick LMS Synthesizer DLL
//
// 10/2013	RD	64 Bit DLL version.	
// 
// 6/2018	RD	added API for external sweep control
//
// 5/2023	RD	added initial Ex functions for 40 GHz BLX-403 devices
//
// 8/2025	NB  added a couple status returns
// 
// This is the ANSI C calling convention DLL 

// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the VNX_FSYNSTH_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// VNX_LMS_API functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.

#ifdef VNX_FMSYNTH_EXPORTS
#define VNX_LMS_API __declspec(dllexport)
#else
#define VNX_LMS_API __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C" {
#endif


// ----------- Global Equates ------------
#define MAXDEVICES 64
#define MAX_MODELNAME 32
#define SEQ_MAX_ENTRIES 50

// ----------- Data Types ----------------
#define DEVID unsigned int

// ----------- Mode Bit Masks ------------
#define MODE_CHIRP		0x00000010			// bit is 1 for chirping enabled
#define MODE_INTREF		0x00000020			// bit is 1 for internal osc., 0 for external reference
#define MODE_RFON		0x00000040			// bit is 1 for RF on, 0 if RF is off (moved from 0x10 by RD 5/23/21)

#define MODE_SWEEP		0x0000000F			// bottom 4 bits are used to keep the sweep control bits
											// the bit definitions are in LMSHid.h

#define MODE_PWMON		0x00000100			// we keep a copy of the PWM control bits here, 1 for int PWM on
#define MODE_EXTPWM		0x00000200			// 1 for ext. PWM input enabled
#define PWM_MASK		0x00000300
#define MODE_EXTSWTRG	0x00000400			// 1 for ext. sweep trigger enabled

// ----------- Command Equates -----------

#define STOP_SEQUENCE 0						// stop a sequence
#define START_SEQUENCE 1					// start a sequence to run once
#define REPEAT_SEQUENCE 2					// start a repeating sequence
#define PAUSE_SEQUENCE 3					// pause a running sequence
#define RESUME_SEQUENCE 4					// resume a running sequence

// Status returns for commands
#define LVSTATUS int
#define LVSTATUS_EX unsigned int

#define STATUS_OK 0
#define INVALID_DEVID		0x80000000		// MSB is set if the device ID is invalid
#define BAD_PARAMETER		0x80010000		// out of range input -- frequency outside min/max etc.
#define BAD_HID_IO			0x80020000
#define DEVICE_NOT_READY	0x80030000		// device isn't open, no handle, etc.

// Status returns for EX commands that use unsigned 32 bit integers
// These values are above the representation for 42 GHz in 10 Hz units
#define STATUS_OK_EX 0
#define INVALID_DEVID_EX	0xFFFF0000		// if the device ID is invalid, 4,294,901,760 decimal, 
#define BAD_PARAMETER_EX	0xFFFF0001		// out of range input -- frequency outside min/max etc.
#define BAD_HID_IO_EX		0xFFFF0002
#define DEVICE_NOT_READY_EX	0xFFFF0003		// device isn't open, no handle, etc.

#define F_INVALID_DEVID		-1.0			// for functions that return a float
#define F_DEVICE_NOT_READY	-3.0
#define F_BAD_PARAMETER		-4.0

// Status returns for DevStatus

#define DEV_CONNECTED		0x00000001		// LSB is set if a device is connected
#define DEV_OPENED			0x00000002		// set if the device is opened
#define SWP_ACTIVE			0x00000004		// set if the device is sweeping
#define SWP_UP				0x00000008		// set if the device is sweeping up in frequency
#define SWP_REPEAT			0x00000010		// set if the device is in continuous sweep mode
#define SWP_BIDIRECTIONAL	0x00000020		// set if the device is in bi-directional sweep mode

#define PLL_LOCKED			0x00000040		// set if the PLL lock status is TRUE (both PLL's are locked)
#define	FAST_PULSE_OPTION	0x00000080		// set if the fast pulse mode option is installed

// Internal values in DevStatus
#define DEV_LOCKED	  0x00002000		// set if we don't want read thread updates of the device parameters
#define DEV_RDTHREAD  0x00004000		// set when the read thread is running


// Flags to encode pulse mode time ranges
#define PM48Mhz				0x10000000		// used to select the 48Mhz pulse mod clock
#define PM1Mhz				0x00000000		// used to select the 1Mhz pulse mod clock or sw pulsing
#define PM120MHz			0x40000000		// used to select the 120Mhz pulse mode clock

VNX_LMS_API void fnLMS_SetTraceLevel(int trace, int devtrace, bool verbose);
VNX_LMS_API void fnLMS_SetTestMode(bool testmode);
VNX_LMS_API int fnLMS_GetNumDevices();
VNX_LMS_API int fnLMS_GetDevInfo(DEVID* ActiveDevices);
VNX_LMS_API int fnLMS_GetModelNameA(DEVID deviceID, char* ModelName);
VNX_LMS_API int fnLMS_GetModelNameW(DEVID deviceID, wchar_t* ModelName);
VNX_LMS_API int fnLMS_InitDevice(DEVID deviceID);
VNX_LMS_API int fnLMS_CloseDevice(DEVID deviceID);
VNX_LMS_API int fnLMS_GetSerialNumber(DEVID deviceID);
VNX_LMS_API int fnLMS_GetDLLVersion();


VNX_LMS_API LVSTATUS fnLMS_SetFrequency(DEVID deviceID, int frequency);
VNX_LMS_API LVSTATUS fnLMS_SetFrequencyEx(DEVID deviceID, unsigned int frequency);

VNX_LMS_API LVSTATUS fnLMS_SetStartFrequency(DEVID deviceID, int startfrequency);
VNX_LMS_API LVSTATUS fnLMS_SetStartFrequencyEx(DEVID deviceID, unsigned int startfrequency);
VNX_LMS_API LVSTATUS fnLMS_SetEndFrequency(DEVID deviceID, int endfrequency);
VNX_LMS_API LVSTATUS fnLMS_SetEndFrequencyEx(DEVID deviceID, unsigned int endfrequency);
VNX_LMS_API LVSTATUS fnLMS_SetSweepTime(DEVID deviceID, int sweeptime);

VNX_LMS_API LVSTATUS fnLMS_SetFrequencyStep(DEVID deviceID, unsigned int frequency);
VNX_LMS_API LVSTATUS fnLMS_SetDwellTime(DEVID deviceID, int dwelltime);
VNX_LMS_API LVSTATUS fnLMS_SetIdleTime(DEVID deviceID, int idletime);

VNX_LMS_API LVSTATUS fnLMS_SetPowerLevel(DEVID deviceID, int powerlevel);
VNX_LMS_API LVSTATUS fnLMS_SetRFOn(DEVID deviceID, bool on);

VNX_LMS_API LVSTATUS fnLMS_SetPulseOnTime(DEVID deviceID, float pulseontime);
VNX_LMS_API LVSTATUS fnLMS_SetPulseOffTime(DEVID deviceID, float pulseofftime);
VNX_LMS_API LVSTATUS fnLMS_EnableInternalPulseMod(DEVID deviceID, bool on);
VNX_LMS_API LVSTATUS fnLMS_SetUseExternalPulseMod(DEVID deviceID, bool external);

VNX_LMS_API LVSTATUS fnLMS_SetFastPulsedOutput(DEVID deviceID, float pulseontime, float pulsereptime, bool on);


VNX_LMS_API LVSTATUS fnLMS_SetUseInternalRef(DEVID deviceID, bool internal);
VNX_LMS_API LVSTATUS fnLMS_SetSweepDirection(DEVID deviceID, bool up);
VNX_LMS_API LVSTATUS fnLMS_SetSweepMode(DEVID deviceID, bool mode);
VNX_LMS_API LVSTATUS fnLMS_SetSweepType(DEVID deviceID, bool swptype);
VNX_LMS_API LVSTATUS fnLMS_StartSweep(DEVID deviceID, bool go);
VNX_LMS_API LVSTATUS fnLMS_SetUseExternalSweepTrigger(DEVID deviceID, bool external);

VNX_LMS_API LVSTATUS fnLMS_SetChirpMode(DEVID deviceID, bool mode);
VNX_LMS_API LVSTATUS fnLMS_SetChirpLength(DEVID deviceID, float chirplength);
VNX_LMS_API LVSTATUS fnLMS_SetChirpRepeatRate(DEVID deviceID, float chirp_repeat);

VNX_LMS_API LVSTATUS fnLMS_SetSequenceElement(DEVID deviceID, int index, unsigned int frequency, int powerlevel, bool pwr_control);
VNX_LMS_API LVSTATUS fnLMS_SetSequenceStart(DEVID deviceID, int start);
VNX_LMS_API LVSTATUS fnLMS_SetSequenceCount(DEVID deviceID, int count);
VNX_LMS_API LVSTATUS fnLMS_SetSequenceDwellTime(DEVID deviceID, int dwelltime);
VNX_LMS_API LVSTATUS fnLMS_SetSequenceIdleTime(DEVID deviceID, int idletime);
VNX_LMS_API LVSTATUS fnLMS_StartSequence(DEVID deviceID, int control);

VNX_LMS_API LVSTATUS fnLMS_SaveSettings(DEVID deviceID);

VNX_LMS_API int fnLMS_GetFrequency(DEVID deviceID);
VNX_LMS_API unsigned int fnLMS_GetFrequencyEx(DEVID deviceID);

VNX_LMS_API int fnLMS_GetStartFrequency(DEVID deviceID);
VNX_LMS_API unsigned int fnLMS_GetStartFrequencyEx(DEVID deviceID);
VNX_LMS_API int fnLMS_GetEndFrequency(DEVID deviceID);
VNX_LMS_API unsigned int fnLMS_GetEndFrequencyEx(DEVID deviceID);
VNX_LMS_API int fnLMS_GetSweepTime(DEVID deviceID);

VNX_LMS_API unsigned int fnLMS_GetFrequencyStepEx(DEVID deviceID);
VNX_LMS_API int fnLMS_GetDwellTime(DEVID deviceID);
VNX_LMS_API int fnLMS_GetIdleTime(DEVID deviceID);

VNX_LMS_API int fnLMS_GetRF_On(DEVID deviceID);
VNX_LMS_API int fnLMS_GetUseInternalRef(DEVID deviceID);
VNX_LMS_API int fnLMS_GetPowerLevel(DEVID deviceID);
VNX_LMS_API int fnLMS_GetAbsPowerLevel(DEVID deviceID);
VNX_LMS_API int fnLMS_GetMaxPwr(DEVID deviceID);
VNX_LMS_API int fnLMS_GetMinPwr(DEVID deviceID);
VNX_LMS_API int fnLMS_GetMaxFreq(DEVID deviceID);
VNX_LMS_API unsigned int fnLMS_GetMaxFreqEx(DEVID deviceID);
VNX_LMS_API int fnLMS_GetMinFreq(DEVID deviceID);
VNX_LMS_API unsigned int fnLMS_GetMinFreqEx(DEVID deviceID);

VNX_LMS_API float fnLMS_GetPulseOnTime(DEVID deviceID);
VNX_LMS_API float fnLMS_GetPulseOffTime(DEVID deviceID);
VNX_LMS_API int fnLMS_GetPulseMode(DEVID deviceID);

VNX_LMS_API float fnLMS_GetChirpLength(DEVID deviceID);
VNX_LMS_API float fnLMS_GetChirpRepeatRate(DEVID deviceID);
VNX_LMS_API int fnLMS_GetHasChirpMode(DEVID deviceID);

VNX_LMS_API int fnLMS_GetHasFastPulseMode(DEVID deviceID);
VNX_LMS_API int fnLMS_GetUseInternalPulseMod(DEVID deviceID);
VNX_LMS_API int fnLMS_GetUseInternalSweepTrigger(DEVID deviceID);

VNX_LMS_API unsigned int fnLMS_GetSeqElementFrequency(DEVID deviceID, int index);
VNX_LMS_API int fnLMS_GetSeqElementPower(DEVID deviceID, int index);
VNX_LMS_API int fnLMS_GetSeqElementPwrControl(DEVID deviceID, int index);
VNX_LMS_API int fnLMS_GetSequenceStart(DEVID deviceID);
VNX_LMS_API int fnLMS_GetSequenceCount(DEVID deviceID);
VNX_LMS_API int fnLMS_GetSequenceDwellTime(DEVID deviceID);
VNX_LMS_API int fnLMS_GetSequenceIdleTime(DEVID deviceID);

VNX_LMS_API int fnLMS_GetDeviceStatus(DEVID deviceID);

#ifdef __cplusplus
}
#endif